/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestObjective;
import noppes.npcs.util.Util;

public class QuestInterface {
    private int id = 0;
    public NpcMiscInventory items = new NpcMiscInventory(1);
    public QuestObjective[] tasks = new QuestObjective[0];

    public QuestObjective addTask(EnumQuestTask type) {
        if (this.tasks.length >= 9) {
            return null;
        }
        QuestObjective[] ts = new QuestObjective[this.tasks.length + 1];
        System.arraycopy(this.tasks, 0, ts, 0, this.tasks.length);
        ts[this.tasks.length] = new QuestObjective(this.id, type);
        this.tasks = ts;
        this.fix();
        return this.tasks[this.tasks.length - 1];
    }

    public void downPos(QuestObjective task) {
        QuestObjective[] ts = new QuestObjective[this.tasks.length];
        try {
            int j = 0;
            for (int i = 0; i < this.tasks.length; ++i) {
                if (this.tasks[i] == task) continue;
                ts[j] = this.tasks[i];
                ++j;
                if (i - 1 < 0 || this.tasks[i - 1] != task) continue;
                ts[j] = this.tasks[i - 1];
                ++j;
            }
            this.tasks = ts;
            this.fix();
        }
        catch (Exception e) {
            LogWriter.error("CNPCs Error ", e);
        }
    }

    public void fix() {
        int i;
        ArrayList<QuestObjective> tsl = new ArrayList<QuestObjective>();
        TreeMap<Integer, ItemStack> stacks = new TreeMap<Integer, ItemStack>();
        for (int i2 = 0; i2 < this.tasks.length; ++i2) {
            if (this.tasks[i2] == null) continue;
            QuestObjective to = this.tasks[i2];
            if (to.getMaxProgress() <= 0) {
                to.setMaxProgress(1);
            }
            stacks.put(i2, ItemStack.field_190927_a);
            if (to.getEnumType() == EnumQuestTask.ITEM || to.getEnumType() == EnumQuestTask.CRAFT) {
                stacks.put(i2, to.getItemStack());
            } else if (to.getEnumType() == EnumQuestTask.AREAKILL) {
                if (to.getAreaRange() < 3) {
                    to.setAreaRange(3);
                } else if (to.getAreaRange() > 32) {
                    to.setAreaRange(24);
                }
            }
            tsl.add(to);
        }
        QuestObjective[] ts = new QuestObjective[tsl.size()];
        for (i = 0; i < tsl.size(); ++i) {
            ts[i] = (QuestObjective)tsl.get(i);
        }
        this.tasks = ts;
        this.items = new NpcMiscInventory(stacks.size());
        for (i = 0; i < stacks.size(); ++i) {
            this.items.func_70299_a(i, (ItemStack)stacks.get(i));
        }
    }

    public boolean getFound(QuestData data, QuestObjective object) {
        boolean isFound = false;
        for (NBTBase dataNBT : data.extraData.func_150295_c("Locations", 10)) {
            if (!object.getTargetName().equalsIgnoreCase(((NBTTagCompound)dataNBT).func_74779_i("Location")) || !((NBTTagCompound)dataNBT).func_74767_n("Found")) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public int getId() {
        return this.id;
    }

    public Map<String, QuestObjective> getKeys() {
        HashMap<String, QuestObjective> keys = new HashMap<String, QuestObjective>();
        String chr = "\u00a7";
        block8: for (int i = 0; i < this.tasks.length; ++i) {
            QuestObjective to = this.tasks[i];
            String key = i + 1 + "-";
            switch (to.getEnumType()) {
                case DIALOG: {
                    String name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    Dialog d = DialogController.instance.dialogs.get(to.getTargetID());
                    if (d != null) {
                        name = chr + "8" + Util.instance.deleteColor(new TextComponentTranslation(d.category.getName(), new Object[0]).func_150254_d()) + "/" + chr + "r" + new TextComponentTranslation(d.getName(), new Object[0]).func_150254_d();
                    }
                    key = key + "[" + chr + "bDr" + chr + "r] " + name;
                    keys.put(key, to);
                    continue block8;
                }
                case KILL: {
                    String name = new TextComponentTranslation("entity." + to.getTargetName() + ".name", new Object[0]).func_150254_d();
                    if (to.getTargetName().isEmpty()) {
                        name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    } else if (name.indexOf("entity.") == 0 && name.indexOf(".name") > 0) {
                        name = to.getTargetName();
                    }
                    key = key + "[" + chr + "cK" + chr + "r] " + name + " = " + to.getMaxProgress();
                    keys.put(key, to);
                    continue block8;
                }
                case AREAKILL: {
                    String name = new TextComponentTranslation("entity." + to.getTargetName() + ".name", new Object[0]).func_150254_d();
                    if (to.getTargetName().isEmpty()) {
                        name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    } else if (name.indexOf("entity.") == 0 && name.indexOf(".name") > 0) {
                        name = to.getTargetName();
                    }
                    key = key + "[" + chr + "4AK" + chr + "r] " + name + " = " + to.getMaxProgress();
                    keys.put(key, to);
                    continue block8;
                }
                case LOCATION: {
                    String name = to.getTargetName();
                    if (to.getTargetName().isEmpty()) {
                        name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    }
                    key = key + "[" + chr + "2L" + chr + "r] " + name;
                    keys.put(key, to);
                    continue block8;
                }
                case MANUAL: {
                    String name = to.getTargetName();
                    if (to.getTargetName().isEmpty()) {
                        name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    }
                    key = key + "[" + chr + "dM" + chr + "r] " + name + " = " + to.getMaxProgress();
                    keys.put(key, to);
                    continue block8;
                }
                case CRAFT: {
                    String name = to.getItemStack().func_82833_r();
                    if (to.getItemStack().func_190926_b()) {
                        name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    }
                    key = key + "[" + chr + "eIc" + chr + "r] " + name + " = " + to.getMaxProgress();
                    keys.put(key, to);
                    continue block8;
                }
                default: {
                    String name = to.getItemStack().func_82833_r();
                    if (to.getItemStack().func_190926_b()) {
                        name = new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d();
                    }
                    key = key + "[" + chr + "6If" + chr + "r] " + name + " = " + to.getMaxProgress();
                    keys.put(key, to);
                }
            }
        }
        return keys;
    }

    public QuestObjective[] getObjectives(EntityPlayer player) {
        QuestObjective[] array = new QuestObjective[this.tasks.length];
        for (int i = 0; i < this.tasks.length; ++i) {
            array[i] = this.tasks[i].copyToPlayer(player);
        }
        return array;
    }

    public int getPos(QuestObjective task) {
        for (int i = 0; i < this.tasks.length; ++i) {
            if (this.tasks[i] != task) continue;
            return i;
        }
        return -1;
    }

    public void handleComplete(EntityPlayer player) {
        boolean bo = false;
        block0: for (QuestObjective to : this.tasks) {
            if (to.getEnumType() != EnumQuestTask.ITEM || to.getItemStack().func_190926_b() || !to.isItemLeave()) continue;
            int stacksize = to.getMaxProgress();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (NoppesUtilServer.IsItemStackNull(stack) || !NoppesUtilPlayer.compareItems(stack, to.getItemStack(), to.isIgnoreDamage(), to.isItemIgnoreNBT())) continue;
                bo = true;
                int size = stack.func_190916_E();
                if (stacksize - size >= 0) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    stack.func_77979_a(size);
                } else {
                    stack.func_77979_a(stacksize);
                }
                if ((stacksize -= size) <= 0) continue block0;
            }
        }
        if (bo) {
            player.field_71069_bz.func_75142_b();
        }
    }

    public boolean isCompleted(EntityPlayer player) {
        PlayerData playerdata = PlayerData.get(player);
        QuestData data = playerdata.questData.activeQuests.get(this.id);
        if (data == null) {
            return false;
        }
        boolean complete = true;
        for (QuestObjective to : this.tasks) {
            block0 : switch (to.getEnumType()) {
                case DIALOG: {
                    complete = playerdata.dialogData.has(to.getTargetID());
                    break;
                }
                case LOCATION: {
                    complete = this.getFound(data, to);
                    break;
                }
                case KILL: {
                    HashMap<String, Integer> killed = to.getKilled(data);
                    if (killed.isEmpty()) {
                        complete = false;
                    }
                    for (String entity : killed.keySet()) {
                        if (!entity.equalsIgnoreCase(to.getTargetName())) continue;
                        if (killed.get(entity) >= to.getMaxProgress()) break block0;
                        complete = false;
                        break block0;
                    }
                    break;
                }
                case AREAKILL: 
                case MANUAL: {
                    HashMap<String, Integer> killed = to.getKilled(data);
                    for (String entity : killed.keySet()) {
                        if (!entity.equalsIgnoreCase(to.getTargetName())) continue;
                        if (killed.get(entity) >= to.getMaxProgress()) break block0;
                        complete = false;
                        break block0;
                    }
                    break;
                }
                case CRAFT: {
                    HashMap<ItemStack, Integer> crafted = to.getCrafted(data);
                    for (ItemStack item : crafted.keySet()) {
                        if (!NoppesUtilPlayer.compareItems(to.getItemStack(), item, to.isIgnoreDamage(), to.isItemIgnoreNBT())) continue;
                        if (crafted.get(item) >= to.getMaxProgress()) break block0;
                        complete = false;
                        break block0;
                    }
                    break;
                }
                default: {
                    complete = NoppesUtilPlayer.compareItems(player, to.getItemStack(), to.isIgnoreDamage(), to.isItemIgnoreNBT(), to.getMaxProgress());
                }
            }
            if (data.quest == null) continue;
            if (!complete && data.quest.step != 2) {
                return false;
            }
            if (!complete || data.quest.step != 2) continue;
            return true;
        }
        return complete;
    }

    public void readEntityFromNBT(NBTTagCompound compound, int id) {
        this.id = id;
        if (!compound.func_150297_b("Tasks", 9)) {
            ArrayList<QuestObjective> oldTasks = new ArrayList<QuestObjective>();
            if (compound.func_74762_e("Type") == 0) {
                this.items = new NpcMiscInventory(compound.func_74775_l("Items").func_150295_c("NpcMiscInv", 10).func_74745_c());
                this.items.load(compound.func_74775_l("Items"));
                for (ItemStack item : this.items.items) {
                    QuestObjective to = new QuestObjective(this.id, EnumQuestTask.ITEM);
                    to.setItem(item);
                    to.setItemLeave(compound.func_74767_n("LeaveItems"));
                    to.setItemIgnoreDamage(compound.func_74767_n("IgnoreDamage"));
                    to.setItemIgnoreNBT(compound.func_74767_n("IgnoreNBT"));
                    oldTasks.add(to);
                }
            } else if (compound.func_74762_e("Type") == 1) {
                HashMap<Integer, Integer> dialogs = NBTTags.getIntegerIntegerMap(compound.func_150295_c("QuestDialogs", 10));
                for (int dId : dialogs.values()) {
                    QuestObjective to = new QuestObjective(this.id, EnumQuestTask.DIALOG);
                    to.setTargetID(dId);
                    oldTasks.add(to);
                }
            } else if (compound.func_74762_e("Type") == 2 || compound.func_74762_e("Type") == 4) {
                TreeMap<String, Integer> targets = new TreeMap<String, Integer>(NBTTags.getStringIntegerMap(compound.func_150295_c("QuestDialogs", 10)));
                for (String name : targets.keySet()) {
                    QuestObjective to = new QuestObjective(this.id, EnumQuestTask.values()[compound.func_74762_e("Type")]);
                    to.setTargetName(name);
                    to.setMaxProgress(targets.get(name));
                    oldTasks.add(to);
                }
            } else if (compound.func_74762_e("Type") == 3) {
                if (compound.func_150297_b("QuestLocation", 8)) {
                    QuestObjective t0 = new QuestObjective(this.id, EnumQuestTask.LOCATION);
                    t0.setTargetName(compound.func_74779_i("QuestLocation"));
                    oldTasks.add(t0);
                }
                if (compound.func_150297_b("QuestLocation2", 8)) {
                    QuestObjective t1 = new QuestObjective(this.id, EnumQuestTask.LOCATION);
                    t1.setTargetName(compound.func_74779_i("QuestLocation2"));
                    oldTasks.add(t1);
                }
                if (compound.func_150297_b("QuestLocation3", 8)) {
                    QuestObjective t2 = new QuestObjective(this.id, EnumQuestTask.LOCATION);
                    t2.setTargetName(compound.func_74779_i("QuestLocation3"));
                    oldTasks.add(t2);
                }
            } else {
                TreeMap<String, Integer> manuals = new TreeMap<String, Integer>(NBTTags.getStringIntegerMap(compound.func_150295_c("QuestManual", 10)));
                for (String name : manuals.keySet()) {
                    QuestObjective to = new QuestObjective(this.id, EnumQuestTask.MANUAL);
                    to.setTargetName(name);
                    to.setMaxProgress(manuals.get(name));
                    oldTasks.add(to);
                }
            }
            this.tasks = oldTasks.toArray(new QuestObjective[Math.min(oldTasks.size(), 9)]);
        } else {
            int i;
            this.tasks = new QuestObjective[compound.func_150295_c("Tasks", 10).func_74745_c()];
            TreeMap<Integer, ItemStack> stacks = new TreeMap<Integer, ItemStack>();
            for (i = 0; i < compound.func_150295_c("Tasks", 10).func_74745_c(); ++i) {
                QuestObjective to = new QuestObjective(this.id, EnumQuestTask.ITEM);
                to.load(compound.func_150295_c("Tasks", 10).func_150305_b(i));
                if (!(to.getEnumType() != EnumQuestTask.ITEM && to.getEnumType() != EnumQuestTask.CRAFT || to.getItemStack().func_190926_b())) {
                    stacks.put(i, to.getItemStack());
                } else {
                    stacks.put(i, ItemStack.field_190927_a);
                }
                this.tasks[i] = to;
            }
            this.items = new NpcMiscInventory(stacks.size());
            for (i = 0; i < stacks.size(); ++i) {
                this.items.items.set(i, stacks.get(i));
            }
        }
        this.fix();
    }

    public boolean removeTask(QuestObjective task) {
        if (task == null) {
            return false;
        }
        QuestObjective[] ts = new QuestObjective[this.tasks.length - 1];
        boolean del = false;
        int j = 0;
        for (int i = 0; i < this.tasks.length; ++i) {
            if (this.tasks[i] == task) {
                del = true;
                continue;
            }
            ts[j] = this.tasks[i];
            ++j;
        }
        if (del) {
            this.tasks = ts;
            this.fix();
        }
        return del;
    }

    public boolean setFound(QuestData data, String location) {
        if (data == null || data.quest.id != this.id) {
            return false;
        }
        for (QuestObjective to : this.tasks) {
            if (to.getEnumType() != EnumQuestTask.LOCATION || !location.equalsIgnoreCase(to.getTargetName())) continue;
            NBTTagCompound dataNBT = new NBTTagCompound();
            dataNBT.func_74778_a("Location", to.getTargetName());
            dataNBT.func_74757_a("Found", true);
            if (data.extraData.func_150295_c("Locations", 10).func_74745_c() == 0) {
                NBTTagList list = new NBTTagList();
                list.func_74742_a((NBTBase)dataNBT);
                data.extraData.func_74782_a("Locations", (NBTBase)list);
                return true;
            }
            boolean found = false;
            for (int i = 0; i < data.extraData.func_150295_c("Locations", 10).func_74745_c(); ++i) {
                NBTTagCompound dataLoc = data.extraData.func_150295_c("Locations", 10).func_150305_b(i);
                if (!location.equalsIgnoreCase(dataLoc.func_74779_i("Location"))) continue;
                if (dataLoc.func_74767_n("Found")) {
                    return false;
                }
                data.extraData.func_150295_c("Locations", 10).func_150305_b(i).func_74757_a("Found", true);
                found = true;
                break;
            }
            if (found) continue;
            data.extraData.func_150295_c("Locations", 10).func_74742_a((NBTBase)dataNBT);
            return true;
        }
        return false;
    }

    public void upPos(QuestObjective task) {
        QuestObjective[] ts = new QuestObjective[this.tasks.length];
        try {
            int j = 0;
            for (int i = 0; i < this.tasks.length; ++i) {
                if (this.tasks[i] == task) continue;
                if (i + 1 < this.tasks.length && this.tasks[i + 1] == task) {
                    ts[j] = this.tasks[i + 1];
                    ++j;
                }
                ts[j] = this.tasks[i];
                ++j;
            }
            this.tasks = ts;
            this.fix();
        }
        catch (Exception e) {
            LogWriter.error("CNPCs Error ", e);
        }
    }

    public void writeEntityToNBT(NBTTagCompound compound) {
        this.fix();
        NBTTagList list = new NBTTagList();
        for (QuestObjective task : this.tasks) {
            list.func_74742_a((NBTBase)task.getNBT());
        }
        compound.func_74782_a("Tasks", (NBTBase)list);
    }
}

